export async function loadPuzzles() {
  try {
    const res = await fetch("/puzzles.json");
    if (!res.ok)
      throw new Error(`Failed to load puzzles.json (status ${res.status})`);
    const data = await res.json();
    return Array.isArray(data) ? data : data.levels || [];
  } catch (err) {
    console.error("Error loading puzzles:", err);
    return [];
  }
}
